package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.db.GroupDAO;
import gov.va.vinci.dart.service.DartObjectFactory;

public class GroupDAOMock implements GroupDAO {
	private static final HashMap<Integer,Group> IDHash = new HashMap<Integer,Group>();
	private static final HashMap<String,Group> NameHash = new HashMap<String,Group>();
	
	private static boolean initialized = false;

	
	@Override
	public Group findById(int groupId) throws ObjectNotFoundException {
		initializeGroupHash();

		Group result = IDHash.get(groupId);
		
		if (result == null) {
			throw new ObjectNotFoundException("Group " + groupId + " not found.");
		}

		return result;
	}

	@Override
	public Group findByName(String name) throws ObjectNotFoundException {
		initializeGroupHash();

		Group result = NameHash.get(name);
		
		if (result == null) {
			throw new ObjectNotFoundException("Group \'" + name + "\' not found.");
		}

		return result;
	}

	@Override
	public List<Group> listAll() {
		List<Group> result = new ArrayList<Group>();
		
		initializeGroupHash();

		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	private void createGroup(final int id, final String name, final int[] personIds) throws ObjectNotFoundException {
		Group group = new Group();
		group.setId(id);
		group.setName(name);
		group.setMembers(new HashSet<Person>());
		
		if (personIds != null && personIds.length > 0) {
			for (int i : personIds) {
				group.getMembers().add(Person.findById(i));
			}
		}
		
		group.setSupportedRoles(new HashSet<Role>());
		
		IDHash.put(group.getId(), group);
		NameHash.put(group.getName(), group);
	}
	
	private void initializeGroupHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		try {
			initializeGroupHash0();
		} catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeGroupHash0() throws ObjectNotFoundException {
		
		createGroup(1, "DART NDS Administrators", null);
		createGroup(2, "DART NDS Administrators Communication", null);
		createGroup(3, "DART Privacy Administrators", null);
		createGroup(4, "DART Privacy Administrators Communication", null);
		createGroup(5, "DART Security Administrators", null);
		createGroup(6, "DART Security Administrators Communication", null);
		createGroup(7, "DART ORD Administrators", null);
		createGroup(8, "DART ORD Administrators Communication", null);
		createGroup(9, "OEF-OIF Administrators", null);
		createGroup(10, "OEF-OIF Administrators Communication", null);
		createGroup(11, "DART Surgery Administrators", null);
		createGroup(12, "DART Surgery Administrators Communication", null);
		createGroup(13, "CAPRI Administrators", null);
		createGroup(14, "VistAWeb Administrators", null);
		createGroup(15, "DART Admin Group", null);
		createGroup(16, "Homeless Registry Administrators", null);
		
		// add some roles
		Group grp = IDHash.get(1);
		Role role = DartObjectFactory.getInstance().getRoleDAO().findById(4);
		grp.getSupportedRoles().add(role);
	}

}
